/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiEditArray;
import net.minecraftforge.fml.client.config.GuiEditArrayEntries;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.FMLLog;
import noppes.npcs.api.mixin.client.config.IGuiEditArrayMixin;
import noppes.npcs.client.gui.SubGuiColorSelector;
import noppes.npcs.client.gui.config.CustomNpcsConfigGui;

public class CustomGuiEditArrayEntries
extends GuiEditArrayEntries {
    protected GuiEditArray owningGui;
    public IConfigElement configElement;
    public List<GuiEditArrayEntries.IArrayEntry> listEntries;
    public boolean isDefault;
    public boolean isChanged;
    public boolean canAddMoreEntries;
    public final int controlWidth;
    public final Object[] beforeValues;
    public Object[] currentValues;

    public CustomGuiEditArrayEntries(GuiEditArray parent, Minecraft mc, IConfigElement configElement, Object[] beforeValues, Object[] currentValues) {
        super(parent, mc, configElement, currentValues, currentValues);
        this.owningGui = parent;
        this.configElement = configElement;
        this.beforeValues = beforeValues;
        this.currentValues = currentValues;
        this.func_193651_b(false);
        this.isChanged = !Arrays.deepEquals(beforeValues, currentValues);
        this.isDefault = Arrays.deepEquals(currentValues, configElement.getDefaults());
        this.canAddMoreEntries = !configElement.isListLengthFixed() && (configElement.getMaxListLength() == -1 || currentValues.length < configElement.getMaxListLength());
        this.listEntries = new ArrayList<GuiEditArrayEntries.IArrayEntry>();
        this.controlWidth = parent.field_146294_l / 2 - (configElement.isListLengthFixed() ? 0 : 48);
        if (configElement.isList() && configElement.getArrayEntryClass() != null) {
            Class clazz = configElement.getArrayEntryClass();
            for (Object value : currentValues) {
                try {
                    this.listEntries.add((GuiEditArrayEntries.IArrayEntry)clazz.getConstructor(GuiEditArray.class, CustomGuiEditArrayEntries.class, IConfigElement.class, Object.class).newInstance(new Object[]{this.owningGui, this, configElement, value}));
                }
                catch (Throwable e) {
                    FMLLog.log.error("There was a critical error instantiating the custom IGuiEditListEntry for property {}.", (Object)configElement.getName(), (Object)e);
                }
            }
        } else if (configElement.isList() && configElement.getType().equals((Object)ConfigGuiType.BOOLEAN)) {
            for (Object value : currentValues) {
                this.listEntries.add(new BooleanEntry(this.owningGui, this, configElement, Boolean.parseBoolean(value.toString())));
            }
        } else if (configElement.isList() && configElement.getType().equals((Object)ConfigGuiType.INTEGER)) {
            for (Object value : currentValues) {
                this.listEntries.add(new IntegerEntry(this.owningGui, this, configElement, Integer.parseInt(value.toString())));
            }
        } else if (configElement.isList() && configElement.getType().equals((Object)ConfigGuiType.DOUBLE)) {
            for (Object value : currentValues) {
                this.listEntries.add(new DoubleEntry(this.owningGui, this, configElement, Double.parseDouble(value.toString())));
            }
        } else if (configElement.isList() && configElement.getType().equals((Object)ConfigGuiType.COLOR)) {
            for (Object value : currentValues) {
                this.listEntries.add(new ColorEntry(this.owningGui, this, configElement, value.toString()));
            }
        } else if (configElement.isList()) {
            for (Object value : currentValues) {
                this.listEntries.add(new StringEntry(this.owningGui, this, configElement, value.toString()));
            }
        }
        if (!configElement.isListLengthFixed()) {
            this.listEntries.add(new BaseEntry(this.owningGui, this, configElement));
        }
    }

    protected void drawScreenPost(int mouseX, int mouseY, float f) {
        for (GuiEditArrayEntries.IArrayEntry entry : this.listEntries) {
            entry.drawToolTip(mouseX, mouseY);
        }
    }

    public GuiEditArrayEntries.IArrayEntry getListEntry(int index) {
        return this.listEntries.get(index);
    }

    public int func_148139_c() {
        return this.owningGui.field_146294_l;
    }

    protected int func_148127_b() {
        return this.listEntries.size();
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    protected boolean isListSavable() {
        for (GuiEditArrayEntries.IArrayEntry entry : this.listEntries) {
            if (entry.isValueSavable()) continue;
            return false;
        }
        return true;
    }

    protected void keyTyped(char eventChar, int eventKey) {
        for (GuiEditArrayEntries.IArrayEntry entry : this.listEntries) {
            entry.keyTyped(eventChar, eventKey);
        }
        this.recalculateState();
    }

    protected void mouseClickedPassThru(int x, int y, int mouseEvent) {
        for (GuiEditArrayEntries.IArrayEntry entry : this.listEntries) {
            entry.mouseClicked(x, y, mouseEvent);
        }
    }

    public void recalculateState() {
        int i;
        int listLength;
        this.isDefault = true;
        this.isChanged = false;
        int n = listLength = this.configElement.isListLengthFixed() ? this.listEntries.size() : this.listEntries.size() - 1;
        if (listLength != this.configElement.getDefaults().length) {
            this.isDefault = false;
        }
        if (listLength != this.beforeValues.length) {
            this.isChanged = true;
        }
        if (this.isDefault) {
            for (i = 0; i < listLength; ++i) {
                if (this.configElement.getDefaults()[i].equals(this.listEntries.get(i).getValue())) continue;
                this.isDefault = false;
            }
        }
        if (!this.isChanged) {
            for (i = 0; i < listLength; ++i) {
                if (this.beforeValues[i].equals(this.listEntries.get(i).getValue())) continue;
                this.isChanged = true;
            }
        }
    }

    protected void saveListChanges() {
        int listLength = this.configElement.isListLengthFixed() ? this.listEntries.size() : this.listEntries.size() - 1;
        int slotIndex = ((IGuiEditArrayMixin)this.owningGui).npcs$getSlotIndex();
        GuiScreen parentScreen = ((IGuiEditArrayMixin)this.owningGui).npcs$getParentScreen();
        if (slotIndex != -1 && parentScreen instanceof GuiConfig && ((GuiConfig)parentScreen).entryList.getListEntry(slotIndex) instanceof GuiConfigEntries.ArrayEntry) {
            GuiConfigEntries.ArrayEntry entry = (GuiConfigEntries.ArrayEntry)((GuiConfig)parentScreen).entryList.getListEntry(slotIndex);
            Object[] ao = new Object[listLength];
            for (int i = 0; i < listLength; ++i) {
                ao[i] = this.listEntries.get(i).getValue();
            }
            entry.setListFromChildScreen(ao);
        } else if (this.configElement.isList() && this.configElement.getType() == ConfigGuiType.BOOLEAN) {
            Object[] abol = new Boolean[listLength];
            for (int i = 0; i < listLength; ++i) {
                abol[i] = Boolean.valueOf(this.listEntries.get(i).getValue().toString());
            }
            this.configElement.set(abol);
        } else if (this.configElement.isList() && this.configElement.getType() == ConfigGuiType.INTEGER) {
            Object[] ai = new Integer[listLength];
            for (int i = 0; i < listLength; ++i) {
                ai[i] = Integer.valueOf(this.listEntries.get(i).getValue().toString());
            }
            this.configElement.set(ai);
        } else if (this.configElement.isList() && this.configElement.getType() == ConfigGuiType.DOUBLE) {
            Object[] ad = new Double[listLength];
            for (int i = 0; i < listLength; ++i) {
                ad[i] = Double.valueOf(this.listEntries.get(i).getValue().toString());
            }
            this.configElement.set(ad);
        } else if (this.configElement.isList()) {
            Object[] as = new String[listLength];
            for (int i = 0; i < listLength; ++i) {
                as[i] = this.listEntries.get(i).getValue().toString();
            }
            this.configElement.set(as);
        }
    }

    protected void updateScreen() {
        for (GuiEditArrayEntries.IArrayEntry entry : this.listEntries) {
            entry.updateCursorCounter();
        }
    }

    public static class StringEntry
    extends BaseEntry {
        protected final GuiTextField textFieldValue;

        public StringEntry(GuiEditArray owningScreen, CustomGuiEditArrayEntries owningEntryList, IConfigElement configElement, Object value) {
            super(owningScreen, owningEntryList, configElement);
            this.textFieldValue = new GuiTextField(0, owningEntryList.getMC().field_71466_p, owningEntryList.field_148155_a / 4 + 1, 0, owningEntryList.controlWidth - 3, 16);
            this.textFieldValue.func_146203_f(10000);
            this.textFieldValue.func_146180_a(value.toString());
            boolean bl = this.isValidated = configElement.getValidationPattern() != null;
            if (configElement.getValidationPattern() != null) {
                this.isValidValue = configElement.getValidationPattern().matcher(this.textFieldValue.func_146179_b().trim()).matches();
            }
        }

        @Override
        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            super.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partial);
            if (this.configElement.isListLengthFixed() || slotIndex != this.owningEntryList.listEntries.size() - 1) {
                this.textFieldValue.func_146189_e(true);
                this.textFieldValue.field_146210_g = y + 1;
                this.textFieldValue.func_146194_f();
            } else {
                this.textFieldValue.func_146189_e(false);
            }
        }

        @Override
        public Object getValue() {
            return this.textFieldValue.func_146179_b().trim();
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            boolean enabled = ((IGuiEditArrayMixin)this.owningScreen).npcs$getEnabled();
            if (enabled || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                this.textFieldValue.func_146201_a(enabled ? eventChar : (char)'\u0000', eventKey);
                if (this.configElement.getValidationPattern() != null) {
                    this.isValidValue = this.configElement.getValidationPattern().matcher(this.textFieldValue.func_146179_b().trim()).matches();
                }
            }
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
            this.textFieldValue.func_146192_a(x, y, mouseEvent);
        }

        @Override
        public void updateCursorCounter() {
            this.textFieldValue.func_146178_a();
        }
    }

    public static class IntegerEntry
    extends StringEntry {
        public IntegerEntry(GuiEditArray owningScreen, CustomGuiEditArrayEntries owningEntryList, IConfigElement configElement, Integer value) {
            super(owningScreen, owningEntryList, configElement, value);
            this.isValidated = true;
        }

        @Override
        public Integer getValue() {
            try {
                return Integer.valueOf(this.textFieldValue.func_146179_b().trim());
            }
            catch (Throwable e) {
                return Integer.MAX_VALUE;
            }
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            boolean enabled = ((IGuiEditArrayMixin)this.owningScreen).npcs$getEnabled();
            if (enabled || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                String validChars = "0123456789";
                String before = this.textFieldValue.func_146179_b();
                if (validChars.contains(String.valueOf(eventChar)) || !before.startsWith("-") && this.textFieldValue.func_146198_h() == 0 && eventChar == '-' || eventKey == 14 || eventKey == 211 || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                    this.textFieldValue.func_146201_a(enabled ? eventChar : (char)'\u0000', eventKey);
                }
                if (!this.textFieldValue.func_146179_b().trim().isEmpty() && !this.textFieldValue.func_146179_b().trim().equals("-")) {
                    try {
                        long value = Long.parseLong(this.textFieldValue.func_146179_b().trim());
                        this.isValidValue = value >= (long)Integer.parseInt(this.configElement.getMinValue().toString()) && value <= (long)Integer.parseInt(this.configElement.getMaxValue().toString());
                    }
                    catch (Throwable e) {
                        this.isValidValue = false;
                    }
                } else {
                    this.isValidValue = false;
                }
            }
        }
    }

    public static class DoubleEntry
    extends StringEntry {
        public DoubleEntry(GuiEditArray owningScreen, CustomGuiEditArrayEntries owningEntryList, IConfigElement configElement, Double value) {
            super(owningScreen, owningEntryList, configElement, value);
            this.isValidated = true;
        }

        @Override
        public Double getValue() {
            try {
                return Double.valueOf(this.textFieldValue.func_146179_b().trim());
            }
            catch (Throwable e) {
                return Double.MAX_VALUE;
            }
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            boolean enabled = ((IGuiEditArrayMixin)this.owningScreen).npcs$getEnabled();
            if (enabled || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                String validChars = "0123456789";
                String before = this.textFieldValue.func_146179_b();
                if (validChars.contains(String.valueOf(eventChar)) || !before.startsWith("-") && this.textFieldValue.func_146198_h() == 0 && eventChar == '-' || !before.contains(".") && eventChar == '.' || eventKey == 14 || eventKey == 211 || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                    this.textFieldValue.func_146201_a(enabled ? eventChar : (char)'\u0000', eventKey);
                }
                if (!this.textFieldValue.func_146179_b().trim().isEmpty() && !this.textFieldValue.func_146179_b().trim().equals("-")) {
                    try {
                        double value = Double.parseDouble(this.textFieldValue.func_146179_b().trim());
                        this.isValidValue = !(value < Double.parseDouble(this.configElement.getMinValue().toString())) && !(value > Double.parseDouble(this.configElement.getMaxValue().toString()));
                    }
                    catch (Throwable e) {
                        this.isValidValue = false;
                    }
                } else {
                    this.isValidValue = false;
                }
            }
        }
    }

    public static class ColorEntry
    extends BaseEntry {
        protected final GuiButtonExt btnValue;
        String value;

        public ColorEntry(GuiEditArray owningScreen, CustomGuiEditArrayEntries owningEntryList, IConfigElement configElement, String string) {
            super(owningScreen, owningEntryList, configElement);
            this.value = string;
            this.btnValue = new GuiButtonExt(0, 0, 0, owningEntryList.controlWidth, 18, I18n.func_135052_a((String)String.valueOf(this.value), (Object[])new Object[0]));
            this.btnValue.field_146124_l = ((IGuiEditArrayMixin)owningScreen).npcs$getEnabled();
            this.isValidated = false;
        }

        @Override
        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            this.btnValue.field_146128_h = listWidth / 4;
            this.btnValue.field_146129_i = y;
            String trans = I18n.func_135052_a((String)String.valueOf(this.value), (Object[])new Object[0]);
            this.btnValue.field_146126_j = !trans.equals(String.valueOf(this.value)) ? trans : String.valueOf(this.value);
            this.btnValue.func_191745_a(this.owningEntryList.getMC(), mouseX, mouseY, partial);
            int left = this.btnValue.field_146128_h + this.btnValue.field_146120_f + 2;
            int right = left + 50;
            GuiUtils.drawGradientRect((int)0, (int)left, (int)y, (int)right, (int)(y + 18), (int)-16777216, (int)-16777216);
            int color = (int)Long.parseLong(this.value, 16);
            float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
            if (alpha == 0.0f) {
                color -= 0x1000000;
            }
            GuiUtils.drawGradientRect((int)0, (int)(left + 1), (int)(y + 1), (int)(right - 1), (int)(y + 17), (int)color, (int)color);
        }

        public GuiButtonExt getButton() {
            return this.btnValue;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnValue.func_146116_c(this.owningEntryList.getMC(), x, y)) {
                CustomNpcsConfigGui.CustomGuiEditArray.subGui = new SubGuiColorSelector((int)Long.parseLong(this.value, 16));
                CustomNpcsConfigGui.CustomGuiEditArray.subGui.field_146294_l = this.owningEntryList.field_148155_a;
                CustomNpcsConfigGui.CustomGuiEditArray.subGui.field_146295_m = this.owningEntryList.field_148158_l;
                CustomNpcsConfigGui.CustomGuiEditArray.subGui.func_73866_w_();
                CustomNpcsConfigGui.CustomGuiEditArray.subGui.parent = this.owningScreen;
                CustomNpcsConfigGui.CustomGuiEditArray.subGui.object = this;
                return true;
            }
            return super.func_148278_a(index, x, y, mouseEvent, relativeX, relativeY);
        }

        @Override
        public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnValue.func_146118_a(x, y);
            super.func_148277_b(index, x, y, mouseEvent, relativeX, relativeY);
        }
    }

    public static class BooleanEntry
    extends BaseEntry {
        protected final GuiButtonExt btnValue;
        private boolean value;

        public BooleanEntry(GuiEditArray owningScreen, CustomGuiEditArrayEntries owningEntryList, IConfigElement configElement, boolean value) {
            super(owningScreen, owningEntryList, configElement);
            this.value = value;
            this.btnValue = new GuiButtonExt(0, 0, 0, owningEntryList.controlWidth, 18, I18n.func_135052_a((String)String.valueOf(value), (Object[])new Object[0]));
            this.btnValue.field_146124_l = ((IGuiEditArrayMixin)owningScreen).npcs$getEnabled();
            this.isValidated = false;
        }

        @Override
        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            super.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partial);
            this.btnValue.field_146128_h = listWidth / 4;
            this.btnValue.field_146129_i = y;
            String trans = I18n.func_135052_a((String)String.valueOf(this.value), (Object[])new Object[0]);
            this.btnValue.field_146126_j = !trans.equals(String.valueOf(this.value)) ? trans : String.valueOf(this.value);
            this.btnValue.packedFGColour = this.value ? GuiUtils.getColorCode((char)'2', (boolean)true) : GuiUtils.getColorCode((char)'4', (boolean)true);
            this.btnValue.func_191745_a(this.owningEntryList.getMC(), mouseX, mouseY, partial);
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnValue.func_146116_c(this.owningEntryList.getMC(), x, y)) {
                this.btnValue.func_146113_a(this.owningEntryList.getMC().func_147118_V());
                this.value = !this.value;
                this.owningEntryList.recalculateState();
                return true;
            }
            return super.func_148278_a(index, x, y, mouseEvent, relativeX, relativeY);
        }

        @Override
        public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnValue.func_146118_a(x, y);
            super.func_148277_b(index, x, y, mouseEvent, relativeX, relativeY);
        }
    }

    public static class BaseEntry
    implements GuiEditArrayEntries.IArrayEntry {
        protected final GuiEditArray owningScreen;
        protected final CustomGuiEditArrayEntries owningEntryList;
        protected final IConfigElement configElement;
        protected boolean isValidValue = true;
        protected boolean isValidated = false;

        public BaseEntry(GuiEditArray owningScreen, CustomGuiEditArrayEntries owningEntryList, IConfigElement configElement) {
            this.owningScreen = owningScreen;
            this.owningEntryList = owningEntryList;
            this.configElement = configElement;
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            if (this.getValue() != null && this.isValidated) {
                this.owningEntryList.getMC().field_71466_p.func_78276_b(this.isValidValue ? TextFormatting.GREEN + "\u2714" : TextFormatting.RED + "\u2715", listWidth / 4 - this.owningEntryList.getMC().field_71466_p.func_78256_a("\u2714") - 2, y + slotHeight / 2 - this.owningEntryList.getMC().field_71466_p.field_78288_b / 2, 0xFFFFFF);
            }
        }

        public void drawToolTip(int mouseX, int mouseY) {
        }

        public Object getValue() {
            return null;
        }

        public boolean isValueSavable() {
            return this.isValidValue;
        }

        public void keyTyped(char eventChar, int eventKey) {
        }

        public void mouseClicked(int x, int y, int mouseEvent) {
        }

        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            return false;
        }

        public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        }

        public void updateCursorCounter() {
        }

        public void func_192633_a(int p_178011_1_, int p_178011_2_, int p_178011_3_, float partial) {
        }
    }
}

